﻿//=============================================================================
// TMPlugin - コスト表示拡張
// バージョン: 1.0.0
// 最終更新日: 2017/09/25
// 配布元    : http://hikimoki.sakura.ne.jp/
//-----------------------------------------------------------------------------
// Copyright (c) 2015 tomoaky
// Released under the MIT license.
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @plugindesc ＭＰ消費とＴＰ消費が両方設定されたスキルのコストを
 * 無理やり両方表示します。
 *
 * @author tomoaky (http://hikimoki.sakura.ne.jp/)
 *
 * @param mpCostHeader
 * @desc 消費MPの頭につける文字列
 * 初期値: MP
 * @default MP
 *
 * @param tpCostHeader
 * @desc 消費TPの頭につける文字列
 * 初期値: TP
 * @default TP
 *
 * @param conjunction
 * @desc コストとコストの間につける文字列
 * 初期値: /
 * @default /
 *
 * @param costWidthText
 * @desc コストの幅として参照する文字列
 * 初期値: 000
 * @default 000
 *
 * @param maxCostNum
 * @type number
 * @desc 同時に表示するコストの上限
 * 初期値: 2
 * @default 2
 *
 * @param ---TMSkillCostEx---
 * @default 以下はTMSkillCostEx併用時に利用
 *
 * @param hpCostHeader
 * @desc 消費HPの頭につける文字列
 * 初期値: HP
 * @default HP
 *
 * @param expCostHeader
 * @desc 消費経験値の頭につける文字列
 * 初期値: EXP
 * @default EXP
 *
 * @param expCostFooter
 * @desc 消費経験値のお尻につける文字列
 * 初期値:
 * @default
 *
 * @param goldCostHeader
 * @desc 消費お金の頭につける文字列
 * 初期値:
 * @default
 *
 * @param goldCostFooter
 * @desc 消費お金のお尻につける文字列
 * 初期値: G
 * @default G
 *
 * @param hpCostColor
 * @type number
 * @desc 消費HPの文字色番号
 * 初期値: 21
 * @default 21
 *
 * @param expCostColor
 * @type number
 * @desc 消費経験値の文字色番号
 * 初期値: 16
 * @default 16
 *
 * @param goldCostColor
 * @type number
 * @desc 消費お金の文字色番号
 * 初期値: 0
 * @default 0
 *
 * @param ---Other---
 * @default -
 *
 * @param itemCostEnoughColor
 * @type number
 * @desc 消費アイテム個数が充足しているときの文字色番号
 * 初期値: 24
 * @default 24
 *
 * @param itemCostLackColor
 * @type number
 * @desc 消費アイテム個数が不足しているときの文字色番号
 * 初期値: 25
 * @default 25
 *
 * @param itemCostCautionColor
 * @type number
 * @desc 消費アイテム個数が少ない時の文字色番号
 * 初期値: 17
 * @default 17
 *
 * @param itemCostCautionMult
 * @type number
 * @decimals 1
 * @desc 消費アイテム個数の何倍以下を「少ない」とするか
 * 初期値: 3
 * @default 3
 *
 * @param itemCostMaxFormat
 * @desc 消費アイテムの最大数のフォーマット
 * @default /%1
 *
 * @help
 * TMPlugin - コスト表示拡張 ver1.0.0
 * 
 * 使い方:
 * 
 *   スキル名が長い場合や、コストの桁数が多い場合にはスキル名とコストが
 *   重なって表示されてしまいます。
 *
 *   パラメータ costWidthText の文字数を変更することで
 *   スキル名の表示幅に上限を設けることができます。
 *   たとえば costWidthText が 00000 の場合、コストの表示幅として
 *   半角の 0 ５文字分を確保し、スキル名の表示幅をその分だけ狭くします。
 *
 *   TMSkillCostEx を併用している場合、消費ＨＰ、経験値、お金も
 *   コスト表示されるようになります。
 * 
 *   プラグインコマンドはありません。
 * 
 *   このプラグインは RPGツクールMV Version 1.5.1 で動作確認をしています。
 * 
 *   このプラグインはMITライセンスのもとに配布しています、商用利用、
 *   改造、再配布など、自由にお使いいただけます。
 */

var Imported = Imported || {};
Imported.TMCostShow = true;

(function() {

  var parameters = PluginManager.parameters('TMCostShow');
  var hpCostHeader = parameters['hpCostHeader'];
  var mpCostHeader = parameters['mpCostHeader'];
  var tpCostHeader = parameters['tpCostHeader'];
  var expCostHeader = parameters['expCostHeader'];
  var expCostFooter = parameters['expCostFooter'];
  var goldCostHeader = parameters['goldCostHeader'];
  var goldCostFooter = parameters['goldCostFooter'];
  var conjunction = parameters['conjunction'];
  var costWidthText = parameters['costWidthText'];
  var maxCostNum = Number(parameters['maxCostNum'])
  var hpCostColor   = Number(parameters['hpCostColor']);
  var expCostColor  = Number(parameters['expCostColor']);
  var goldCostColor = Number(parameters['goldCostColor']);
  var itemCostEnoughColor = Number(parameters['itemCostEnoughColor']);
  var itemCostLackColor = Number(parameters['itemCostLackColor']);
  var itemCostCautionColor = Number(parameters['itemCostCautionColor']);
  var itemCostCautionMult = Number(parameters['itemCostCautionMult']);
  var itemCostMaxFormat = String(parameters['itemCostMaxFormat']);
  
  //-----------------------------------------------------------------------------
  // Window_SkillList
  //
  
  // 再定義
  Window_SkillList.prototype.drawItem = function(index) {
    // Yanfly - TP Mode
    if (this._stypeId === 'tpMode') {
      this.drawTpItem(index);
    }
    // -------------
    var skill = this._data[index];
    if (skill) {
        var rect = this.itemRect(index);
        rect.width -= this.textPadding();
        this.changePaintOpacity(this.isEnabled(skill));
        var costWidth = rect.width - this.drawSkillCost(skill, rect.x, rect.y, rect.width);
        this.drawItemName(skill, rect.x, rect.y, rect.width - costWidth);
        this.changePaintOpacity(1);
    }
  };

  Window_SkillList.prototype.drawSkillCost = function(skill, x, y, width) {
    var mx = x;
    x += width;
    var count = 0;
    if (Imported.YEP_X_SkillCooldowns) {
      if (this._actor.cooldown(skill.id) > 0) {
        return this.drawCooldown(skill, x, y, width);
      }
    }
    var cost = this._actor.skillTpCost(skill);
    if (cost > 0) {
      x = this.drawSkillTpCost(cost, x, y);
      if (count++ === maxCostNum - 1) {
        return (x - mx);
      }
    }
    cost = this._actor.skillMpCost(skill);
    if (cost > 0) {
      x = this.drawSkillMpCost(cost, x, y, count);
      if (count++ === maxCostNum - 1) {
        return (x - mx);
      }
    }
    if (Imported.YEP_SkillCore) {
      cost = this._actor.skillHpCost(skill);
      if (cost > 0) {
        x = this.drawSkillHpCost(cost, x, y, count);
        if (count++ === maxCostNum - 1) {
          return (x - mx);
        }
      }
    }
    if (Imported.TMSkillCostEx) {
      cost = this._actor.skillExpCost(skill);
      if (cost > 0) {
        x = this.drawSkillExpCost(cost, x, y, count);
        if (count++ === maxCostNum - 1) {
          return (x - mx);
        }
      }
      cost = this._actor.skillGoldCost(skill);
      if (cost > 0) {
        x = this.drawSkillGoldCost(cost, x, y, count);
        if (count++ === maxCostNum - 1) {
          return (x - mx);
        }
      }
    }
    if (Imported.YEP_X_SkillCostItems) {
      x = this.drawSkillItemCost(skill, x, y, count);
    }
    return (x - mx);
  };

  Window_SkillList.prototype.drawConjunction = function(x, y) {
    this.resetTextColor();
    x -= this.textWidth(conjunction);
    this.drawText(conjunction, x, y);
    return x;
  };
  
  Window_SkillList.prototype.drawCooldown = function(skill, x, y, dw) {
    this.changeTextColor(this.textColor(Yanfly.Param.CDTextColor));
    var value = this._actor.cooldown(skill.id);
    if (value % 1 !== 0) value = value.toFixed(2);
    if (value <= 0.009) value = 0.01;
    x -= this.textWidth(value);
    this.drawText(value, x, y);
    x -= this.drawSkillCostHeader("CD", x, y);
    return x;
  };

  Window_SkillList.prototype.drawSkillTpCost = function(tpCost, x, y) {
    this.changeTextColor(this.tpCostColor());
    x -= this.textWidth(tpCost);
    this.drawText(tpCost, x, y);
    x -= this.drawSkillCostHeader(tpCostHeader, x, y);
    return x;
  };
  
  Window_SkillList.prototype.drawSkillMpCost = function(mpCost, x, y, count) {
    if (count > 0) {
      x = this.drawConjunction(x, y);
    }
    this.changeTextColor(this.mpCostColor());
    x -= this.textWidth(mpCost);
    this.drawText(mpCost, x, y);
    x -= this.drawSkillCostHeader(mpCostHeader, x, y);
    return x;
  };
  
  Window_SkillList.prototype.drawSkillHpCost = function(hpCost, x, y, count) {
    if (count > 0) {
      x = this.drawConjunction(x, y);
    }
    this.changeTextColor(this.textColor(hpCostColor));
    x -= this.textWidth(hpCost);
    this.drawText(hpCost, x, y);
    x -= this.drawSkillCostHeader(hpCostHeader, x, y);
    return x;
  };
  
  Window_SkillList.prototype.drawSkillExpCost = function(expCost, x, y, count) {
    if (count > 0) {
      x = this.drawConjunction(x, y);
    }
    x -= this.drawSkillCostFooter(expCostFooter, x, y);
    this.changeTextColor(this.textColor(expCostColor));
    x -= this.textWidth(expCost);
    this.drawText(expCost, x, y);
    x -= this.drawSkillCostHeader(expCostHeader, x, y);
    return x;
  };
  
  Window_SkillList.prototype.drawSkillGoldCost = function(goldCost, x, y, count) {
    if (count > 0) {
      x = this.drawConjunction(x, y);
    }
    x -= this.drawSkillCostFooter(goldCostFooter, x, y);
    this.changeTextColor(this.textColor(goldCostColor));
    x -= this.textWidth(goldCost);
    this.drawText(goldCost, x, y);
    x -= this.drawSkillCostHeader(goldCostHeader, x, y);
    return x;
  };
  
  Window_SkillList.prototype.drawSkillCostHeader = function(header, x, y) {
    this.contents.fontSize = this.standardFontSize() - 12;
    var w = this.textWidth(header);
    this.drawText(header, x - w, y + 4, w);
    this.contents.fontSize = this.standardFontSize();
    return w;
  };
  
  Window_SkillList.prototype.drawSkillCostFooter = function(footer, x, y) {
    this.contents.fontSize = this.standardFontSize() - 12;
    this.resetTextColor();
    var w = this.textWidth(footer);
    this.drawText(footer, x - w, y + 4, w);
    this.contents.fontSize = this.standardFontSize();
    return w;
  };
  
  Window_SkillList.prototype.costWidth = function() {
    return this.textWidth(costWidthText);
  };
  
  // 再定義
  Window_SkillList.prototype.drawSkillItemCost = function(skill, x, y, count) {
    if (Yanfly.Param.SCICostStyle === 0) return x;
    var array = this._actor.skillItemCost(skill);
    var max = array.length;
    if (max <= 0) return x;
    x -= 2;
    for (var i = 0; i < max; ++i) {
      var arr = array[max - i - 1];
      var item = arr[0];
      var cost = arr[1];
      if (count > 0) {
        x = this.drawConjunction(x, y);
      }
      x = this.drawSoloItemCost(item, cost, x, y);
    }
    var returnWidth = x - Yanfly.Param.SCCCostPadding;
    this.resetFontSettings();
    return returnWidth;
  };
  
  Window_SkillList.prototype.drawSoloItemCost = function(item, cost, x, y) {
    x -= Window_Base._iconWidth;
    this.drawIcon(item.iconIndex, x, y + 2);
    var amt1 = Yanfly.Util.toGroup(cost);
    var amt2 = Yanfly.Util.toGroup(this._actor.numItems(item));
    var fmt = Yanfly.Param.SCIAmountFmt;
    var text = fmt.format(amt1, amt2);
    var textMax = itemCostMaxFormat.format(amt2);
    var costColor = 0;
    if (amt1 > amt2) {
      costColor = itemCostLackColor;
    } else if (amt1 * itemCostCautionMult >= amt2) {
      costColor = itemCostCautionColor;
    } else {
      costColor = itemCostEnoughColor;
    }
    if (Yanfly.Param.SCICostStyle === 1) {
      var iconWidth = Window_Base._iconWidth + 4;
      x += iconWidth;
      if (textMax) {
        x -= this.drawSkillCostFooter( textMax, x, y);
      }
      this.contents.fontSize = Yanfly.Param.SCIFontSize;
      var dw = this.textWidth(text);
      x -= Math.max(iconWidth, dw);
      this.changeTextColor(this.textColor(costColor));
      this.drawText(text, x, y + Yanfly.Param.SCIYBuffer);
    } else if (Yanfly.Param.SCICostStyle === 2) {
      x -= 2;
      if (textMax) {
        x -= this.drawSkillCostFooter( textMax, x, y);
      }
      this.contents.fontSize = Yanfly.Param.SCIFontSize;
      var dw = this.textWidth(text);
      x -= dw;
      this.changeTextColor(this.textColor(costColor));
      this.drawText(text, x, y + Yanfly.Param.SCIYBuffer);
    }
    return x;
  };

})();